SET QUOTED_IDENTIFIER ON

--empty BMS database
USE $(varBMS)

BEGIN TRAN 

-- TEMPORARY TABLE FOR ACT IDs
DECLARE @ACT_TBL TABLE(ACT_ID int NOT NULL)

-- ADMISSION EVENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.ADMISSION_EVN
TRUNCATE TABLE dbo.ADMISSION_EVN
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- ADMISSION REQUEST
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.ADMISSION_REQ
DELETE FROM dbo.ADMISSION_REQ
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- ADMISSION INTENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.ADMISSION_INT
TRUNCATE TABLE dbo.ADMISSION_INT
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- BED CLEAN
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.BED_CLEAN
TRUNCATE TABLE dbo.BED_CLEAN
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- BED UNAVAILABLE
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.BED_UNAVAILABLE
TRUNCATE TABLE dbo.BED_UNAVAILABLE
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- DISCHARGE EVENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.DISCHARGE_EVN
TRUNCATE TABLE dbo.DISCHARGE_EVN
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- DISCHARGE REQUEST
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.DISCHARGE_REQ
DELETE FROM dbo.DISCHARGE_REQ
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- DISCHARGE INTENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.DISCHARGE_INT
TRUNCATE TABLE dbo.DISCHARGE_INT
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- MOVEMENT EVENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.MOVEMENT_EVN
TRUNCATE TABLE dbo.MOVEMENT_EVN
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- MOVEMENT REQUEST
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.MOVEMENT_REQ
TRUNCATE TABLE dbo.MOVEMENT_REQ
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- MOVEMENT INTENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.MOVEMENT_INT
TRUNCATE TABLE dbo.MOVEMENT_INT
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- TRANSFER EVENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.TRANSFER_EVN
TRUNCATE TABLE dbo.TRANSFER_EVN
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- TRANSFER REQUEST
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.MOVEMENT_REQ
TRUNCATE TABLE dbo.TRANSFER_REQ
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- ACT
DELETE FROM dbo.ACT
DBCC CHECKIDENT (ACT, reseed, 0)

-- DIVERSION
TRUNCATE TABLE dbo.DIVERSION

-- EIS
DELETE FROM dbo.EIS_PLACE
DELETE FROM dbo.EIS_PERSON
DELETE FROM dbo.EIS_ORGANIZATION
DELETE FROM dbo.EIS_ENTITY
DBCC CHECKIDENT (EIS_ENTITY, reseed, 0)
-- EVS
DELETE FROM dbo.CONCEPT
DBCC CHECKIDENT (CONCEPT, reseed, 0)

-- CONFIG
DELETE FROM dbo.CONFIG_EIS
DELETE FROM dbo.CONFIG_EVS
DELETE FROM dbo.CONFIG
DBCC CHECKIDENT (CONFIG_EIS, reseed, 0)
DBCC CHECKIDENT (CONFIG_EVS, reseed, 0)
DBCC CHECKIDENT (CONFIG, reseed, 0)

COMMIT TRAN

-- empty BMS Instance Store - WORKFLOW
USE $(varBMS_InstanceStore)

BEGIN TRAN


delete from [System.Activities.DurableInstancing].[InstancesTable]
delete from [System.Activities.DurableInstancing].[KeysTable]

COMMIT TRAN

--empty BMS_EIS

USE $(varBMS_EIS)

BEGIN TRAN

truncate table ehl7_entity_address
DBCC CHECKIDENT('dbo.ehl7_entity_address',reseed,0)

truncate table ehl7_role_address
DBCC CHECKIDENT('dbo.ehl7_role_address',reseed,0)

delete from ehl7_address
DBCC CHECKIDENT('dbo.ehl7_address',reseed,0)

truncate table ehl7_entity_telecom
DBCC CHECKIDENT('dbo.ehl7_entity_telecom',reseed,0)

truncate table ehl7_role_telecom
DBCC CHECKIDENT('dbo.ehl7_role_telecom',reseed,0)

delete from ehl7_telecom
DBCC CHECKIDENT('dbo.ehl7_telecom',reseed,0)

truncate table EHL7_ROLE_ACCESS

truncate table EHL7_ROLE_EMPLOYEE

truncate table EHL7_ROLE_LICENSED_ENTITY

truncate table EHL7_ROLE_PATIENT

truncate table EHL7_ROLE_QUALIFIED_ENTITY

delete from EHL7_ROLE
DBCC CHECKIDENT('dbo.EHL7_ROLE',reseed,0)

truncate table EHL7_PERSON

truncate table EHL7_PLACE

truncate table EHL7_ORGANIZATION

truncate table EHL7_NON_PERSON_LIVING_SUBJECT

truncate table EHL7_MATERIAL

truncate table EHL7_MANUFACTURED_MATERIAL

truncate table EHL7_CONTAINER

truncate table EHL7_DEVICE

truncate table ENTITY_LINK

truncate table EHL7_UID
DBCC CHECKIDENT('dbo.EHL7_UID',reseed,0)

truncate table TRAIT_VALUE
DBCC CHECKIDENT('dbo.TRAIT_VALUE',reseed,0)

delete from ENTITY
DBCC CHECKIDENT('dbo.entity',reseed,0)

truncate table LINK_ALGORITHM
DBCC CHECKIDENT('dbo.LINK_ALGORITHM',reseed,0)

truncate table wsev.MESSAGES
DBCC CHECKIDENT('wsev.MESSAGES',reseed,0)

delete from wsev.SUBSCRIPTION_FILTERS
DBCC CHECKIDENT('wsev.SUBSCRIPTION_FILTERS',reseed,0)

delete from wsev.SUBSCRIPTIONS
DBCC CHECKIDENT('wsev.SUBSCRIPTIONS',reseed,0)

truncate table ehl7_address_ssisdel;
truncate table ehl7_role_ssisdel;
truncate table ehl7_uid_ssisdel;
truncate table entity_ssisdel;

--start golire tabele securitate
delete from ACTION_ALL

delete from USER_ROLE
delete from POLICY
delete from ROLE
delete from PERMISSION
delete from ACTION_GROUP
delete from ACTION
delete from RESOURCE
--end golire tabele securitate

--start golire tabele sistem (_ssisdel)
DECLARE @TruncateStatement nvarchar(2000)
DECLARE TruncateStatements CURSOR LOCAL FAST_FORWARD
FOR SELECT N'TRUNCATE TABLE ' +
          QUOTENAME(TABLE_SCHEMA) +
          N'.' + QUOTENAME(TABLE_NAME)
FROM
    INFORMATION_SCHEMA.TABLES
WHERE
    TABLE_NAME like '%_ssisdel' 
OPEN TruncateStatements
FETCH NEXT FROM TruncateStatements INTO @TruncateStatement
WHILE @@FETCH_STATUS = 0
BEGIN
    FETCH NEXT FROM TruncateStatements INTO @TruncateStatement
    EXEC(@TruncateStatement)
END
-- Clean up work
CLOSE TruncateStatements
DEALLOCATE TruncateStatements  
--end golire tabele sistem (_ssisdel)

COMMIT TRAN
-- ROLLBACK TRAN

--empty vista DB
use $(varBMS_VISTA)

BEGIN TRAN

truncate table CPRS_ORDERS_LOG
truncate table DISPLAY_GROUP_LOG
truncate table FAC_TREAT_SPECIALTY_LOG
truncate table HOSPITAL_LOCATION_LOG
truncate table ORDER_ACTIONS_LOG
truncate table ORDERABLE_ITEM_LOG
truncate table PATIENT_APPOINTMENT_LOG
truncate table PATIENT_MOVEMENT_LOG
truncate table REGION_LOG
truncate table RMDB_WARDS_WITH_CAN_ASSIGN_LOG
truncate table ROOM_BED_LOG
truncate table SCHEDULED_ADMISSION_LOG
truncate table SPECIALTY_LOG 
truncate table TYPE_OF_MOVEMENT_LOG
truncate table VISN_LOG
truncate table WARD_LOCATION_LOG
truncate table PATIENT_LOG



delete from PATIENT_APPOINTMENT
DBCC CHECKIDENT('dbo.PATIENT_APPOINTMENT',reseed,0)

delete from SCHEDULED_ADMISSION
DBCC CHECKIDENT('dbo.SCHEDULED_ADMISSION',reseed,0)

update PATIENT
set CURRENT_ADMISSION_ID = null, CURRENT_MOVEMENT_ID = null

delete from PATIENT_MOVEMENT
DBCC CHECKIDENT('dbo.PATIENT_MOVEMENT',reseed,0)

delete from PATIENT
DBCC CHECKIDENT('dbo.PATIENT',reseed,0)

delete from FAC_TREAT_SPECIALTY
DBCC CHECKIDENT('dbo.FAC_TREAT_SPECIALTY',reseed,0)

delete from MEDICAL_CENTER_DIVISION
DBCC CHECKIDENT('dbo.MEDICAL_CENTER_DIVISION',reseed,0)

delete from RMDB_WARDS_WITH_CAN_ASSIGN
DBCC CHECKIDENT('dbo.RMDB_WARDS_WITH_CAN_ASSIGN',reseed,0)

delete from ROOM_BED
DBCC CHECKIDENT('dbo.ROOM_BED',reseed,0)

delete from WARD_LOCATION
DBCC CHECKIDENT('dbo.WARD_LOCATION',reseed,0)

delete from SPECIALTY
DBCC CHECKIDENT('dbo.SPECIALTY',reseed,0)

delete from ORDER_ACTIONS

delete from CPRS_ORDERS_ORDERABLE_ITEM

delete from CPRS_ORDERS
DBCC CHECKIDENT('dbo.CPRS_ORDERS',reseed,0)

delete from HOSPITAL_LOCATION
DBCC CHECKIDENT('dbo.HOSPITAL_LOCATION',reseed,0)

delete from ORDER_STATUS
DBCC CHECKIDENT('dbo.ORDER_STATUS',reseed,0)

delete from ORDERABLE_ITEM
DBCC CHECKIDENT('dbo.ORDERABLE_ITEM',reseed,0)

delete from DISPLAY_GROUP
DBCC CHECKIDENT('dbo.DISPLAY_GROUP',reseed,0)

delete from NEW_PERSON 
DBCC CHECKIDENT('dbo.NEW_PERSON',reseed,0)

delete from MARITAL_STATUS
DBCC CHECKIDENT('dbo.MARITAL_STATUS',reseed,0)

delete from VISN 
DBCC CHECKIDENT('dbo.VISN',reseed,0)

delete from REGION
DBCC CHECKIDENT('dbo.REGION',reseed,0)


delete from TYPE_OF_MOVEMENT
DBCC CHECKIDENT('dbo.TYPE_OF_MOVEMENT',reseed,0)


COMMIT TRAN

--clean vista vocabularies from EVS db
use $(varBMS_EVS)

BEGIN TRAN

--delete from coding schemes
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CSTemp]') AND type in (N'U'))
DROP TABLE [dbo].[CSTemp] 
go

CREATE TABLE [dbo].[CSTemp] (
CodingSchemeID nvarchar(max),
 CodingSchemeName nvarchar(max),
 Language nvarchar(max),
 ConceptCode nvarchar(max),
 [Rel:hasSubtype] nvarchar(max),
 ConceptDescription nvarchar(max),
 Status nvarchar(max),
 F10 nvarchar(max),
 F7 nvarchar(max),
 F8 nvarchar(max),
 F9 nvarchar(max))
go
INSERT INTO [dbo].[CSTemp] ([CodingSchemeID], [CodingSchemeName], [Language], [ConceptCode], [Rel:hasSubtype], [ConceptDescription], [Status], [F10], [F7], [F8], [F9])
SELECT
N'2.12.24.38', N'OrderableItem',NULL,C.conceptCode,NULL,NULL,N'1',NULL,NULL,NULL,NULL
FROM concept C where codingSchemeName = 'OrderableItem'
exec EXEC_INSERT_CS_SCRIPT 

TRUNCATE TABLE [dbo].[CSTemp]

--'VistaSpecialty' --2.12.24.39
INSERT INTO [dbo].[CSTemp] ([CodingSchemeID], [CodingSchemeName], [Language], [ConceptCode], [Rel:hasSubtype], [ConceptDescription], [Status], [F10], [F7], [F8], [F9])
SELECT
N'2.12.24.39', N'VistaSpecialty',NULL,C.conceptCode,NULL,NULL,N'1',NULL,NULL,NULL,NULL
FROM concept C where codingSchemeName = 'VistaSpecialty'
exec EXEC_INSERT_CS_SCRIPT 

TRUNCATE TABLE [dbo].[CSTemp]

--'VistaTreatingSpecialty' --2.12.24.44
INSERT INTO [dbo].[CSTemp] ([CodingSchemeID], [CodingSchemeName], [Language], [ConceptCode], [Rel:hasSubtype], [ConceptDescription], [Status], [F10], [F7], [F8], [F9])
SELECT
N'2.12.24.44', N'VistaTreatingSpecialty',NULL,C.conceptCode,NULL,NULL,N'1',NULL,NULL,NULL,NULL
FROM concept C where codingSchemeName = 'VistaTreatingSpecialty'
exec EXEC_INSERT_CS_SCRIPT 

TRUNCATE TABLE [dbo].[CSTemp]

--'TypeOfMovement' --2.12.24.43
INSERT INTO [dbo].[CSTemp] ([CodingSchemeID], [CodingSchemeName], [Language], [ConceptCode], [Rel:hasSubtype], [ConceptDescription], [Status], [F10], [F7], [F8], [F9])
SELECT
N'2.12.24.43', N'TypeOfMovement',NULL,C.conceptCode,NULL,NULL,N'1',NULL,NULL,NULL,NULL
FROM concept C where codingSchemeName = 'TypeOfMovement'
exec EXEC_INSERT_CS_SCRIPT 

TRUNCATE TABLE [dbo].[CSTemp]

--'OrderStatus' --2.12.24.45
INSERT INTO [dbo].[CSTemp] ([CodingSchemeID], [CodingSchemeName], [Language], [ConceptCode], [Rel:hasSubtype], [ConceptDescription], [Status], [F10], [F7], [F8], [F9])
SELECT
N'2.12.24.45', N'OrderStatus',NULL,C.conceptCode,NULL,NULL,N'1',NULL,NULL,NULL,NULL
FROM concept C where codingSchemeName = 'OrderStatus'
exec EXEC_INSERT_CS_SCRIPT 

TRUNCATE TABLE [dbo].[CSTemp]

COMMIT TRAN